def format(type):
    if type=='currency':
        def format(value):
            return("${:,.2f}".format(value))
    if type=='character':
        def format(value):
            return(value.capitalize())
    return format

def format_function(type):
    def format_decorator(function):
        format_type=format(type)
        def format_result(*args, **kwargs):
            x = function(*args, **kwargs)
            return format_type(x)
        return format_result
    return format_decorator
